// $Id: CBpmToTimePanel.cpp,v 1.5 2007/02/11 02:20:27 paul Exp $

/*
 * All contents of this source code are copyright 2007 Exp Digital Uk.
 * This file forms part of the example projects for the Infinity API.
 * You may not redistribute either the source code or the compiled binary.
 * The Infinity API is covered by a fair use licence which you should have recieved with this
 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
 */

#include "CBpmToTimePanel.hpp"
#include "CSCalWindow.hpp"
using Exponent::SCal::CSCalWindow;
using Exponent::SCal::CBpmToTimePanel;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CBpmToTimePanel, CControlPanel);

//	===========================================================================
CBpmToTimePanel::CBpmToTimePanel(IControlRoot *root, const long uniqueId, const CRect &area)
               : CControlPanel(root->getParentWindow(), root, uniqueId, area, NULL)
			   , m_timeFromBpmBpmEditBox(NULL)
			   , m_timeFromBpmBeatsEditBox(NULL)
			   , m_timeFromBpmOutputValueLabel(NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CBpmToTimePanel);

	this->onDrawDrawThePanelBounds(false);

	m_timeFromBpmBpmEditBox			= new CTextEdit( this, e_timeFromBpmBpmEditBox,			  CSCalWindow::CSCALWINDOW_CONTROL1_RECT, "120.00", this);
	m_timeFromBpmBeatsEditBox		= new CTextEdit( this, e_timeFromBpmBeatsEditBox,		  CSCalWindow::CSCALWINDOW_CONTROL2_RECT, "4",      this);
	m_timeFromBpmOutputValueLabel	= new CTextLabel(this, CControl::CCONTROL_NO_ID_REQUIRED, CSCalWindow::CSCALWINDOW_OUTPUTBOX_RECT, CString::CSTRING_EMPTY_STRING);
	
	// Reference
	m_timeFromBpmBpmEditBox->referenced();
	m_timeFromBpmBeatsEditBox->referenced();
	m_timeFromBpmOutputValueLabel->referenced();

	// Set the format
	m_timeFromBpmBpmEditBox->setTextFormat(CGraphics::e_centerCenterAlign);
	m_timeFromBpmBeatsEditBox->setTextFormat(CGraphics::e_centerCenterAlign);
	m_timeFromBpmOutputValueLabel->setTextFormat(CGraphics::e_centerCenterAlign);
	
	m_timeFromBpmBpmEditBox->setAlignment(CTextEdit::e_center);
	m_timeFromBpmBeatsEditBox->setAlignment(CTextEdit::e_center);

	// Make single click editable
	m_timeFromBpmBpmEditBox->setSingleClickEditable();
	m_timeFromBpmBeatsEditBox->setSingleClickEditable();

	// Colours
	m_timeFromBpmBpmEditBox->setColours(		CAlphaColour::CALPHACOLOUR_BLACK, CSCalWindow::CSCALWINDOW_BACKGROUND_COLOUR, CSCalWindow::CSCALWINDOW_TEXT_COLOUR);
	m_timeFromBpmBeatsEditBox->setColours(		CAlphaColour::CALPHACOLOUR_BLACK, CSCalWindow::CSCALWINDOW_BACKGROUND_COLOUR, CSCalWindow::CSCALWINDOW_TEXT_COLOUR);
	m_timeFromBpmOutputValueLabel->setColours(	CAlphaColour::CALPHACOLOUR_BLACK, CAlphaColour::CALPHACOLOUR_WHITE, CSCalWindow::CSCALWINDOW_ANSWER_TEXT_COLOUR);

	// Add
	this->addControl(m_timeFromBpmBpmEditBox); 
	this->addControl(m_timeFromBpmBeatsEditBox);
	this->addControl(m_timeFromBpmOutputValueLabel);

	// Compute
	this->computeTimeFromBpm();
}

//	===========================================================================
CBpmToTimePanel::~CBpmToTimePanel()
{
	EXPONENT_CLASS_DESTRUCTION(CBpmToTimePanel);
	FORGET_COUNTED_OBJECT(m_timeFromBpmBpmEditBox);
	FORGET_COUNTED_OBJECT(m_timeFromBpmBeatsEditBox);
	FORGET_COUNTED_OBJECT(m_timeFromBpmOutputValueLabel);
}

//	===========================================================================
void CBpmToTimePanel::handleActionEvent(const CActionEvent &event)
{
	switch(event.getControl()->getUniqueId())
	{
		case e_timeFromBpmBpmEditBox:
		case e_timeFromBpmBeatsEditBox:
			this->computeTimeFromBpm();
		break;
	}
}

//	===========================================================================
void CBpmToTimePanel::computeTimeFromBpm()
{
	// First we check the bpm
	double bpm = CString::toDouble(m_timeFromBpmBpmEditBox->getString().getString());
	
	if (bpm <= 0.0 || bpm >= 1000.0)
	{
		CDialog::notifyUser("Bpm range error!\n\n0.0 < bpm < 1000.0\n\nBpm must be between 0 and 1000 bpm", "SCal error", true);
		bpm = 120.0;
		m_timeFromBpmBpmEditBox->setText("120.00");
	}
	else
	{
		CString string;
		string.setStringWithFormat("%0.02f", bpm);
		m_timeFromBpmBpmEditBox->setText(string);
	}
	m_timeFromBpmBpmEditBox->update();
	
	// Now check the number of beats
	long beats = CString::toLong(m_timeFromBpmBeatsEditBox->getString().getString());
	
	if (beats <= 0)
	{
		CDialog::notifyUser("Beats range error!\n\n0 < beats\n\nBeats must be greater than 0", "SCal error", true);
		beats = 4;
		m_timeFromBpmBeatsEditBox->setText("4");
	}
	else
	{
		CString string;
		string.setStringWithFormat("%li", beats);
		m_timeFromBpmBeatsEditBox->setText(string);
	}
	m_timeFromBpmBeatsEditBox->update();

	// Store the output
	CString output;
	output.setStringWithFormat("%0.02f", CMusicMath::getBpmFromTime(bpm, CTimeSignature(4, 4), beats));
	m_timeFromBpmOutputValueLabel->setText(output);
	m_timeFromBpmOutputValueLabel->update();
}